/*
*	Standard Application Shell  - C Version
*	       Developer Technical Support
*
*		v3.0 	Mensch, KAAR, Luther
*/

/*
*	 Copyright (c) Apple Computer, Inc. 1988-1990
*				All Rights Reserved.
*
*    Developer Technical Support Apple II Sample Code
*
*	------------------------------------------------------
*
*	This program and its derivatives are licensed only for
*	use on Apple computers.
*
*	Works based on this program must contain and
*	conspicuously display this notice.
*
*	This software is provided for your evaluation and to
*	assist you in developing software for the Apple IIGS
*	computer.
*
*	DISCLAIMER OF WARRANTY
*
*	THE SOFTWARE IS PROVIDED "AS IS" WITHOUT
*	WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED,
*	WITH RESPECT TO ITS MERCHANTABILITY OR ITS FITNESS
*	FOR ANY PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO
*	THE QUALITY AND PERFORMANCE OF THE SOFTWARE IS WITH
*	YOU.  SHOULD THE SOFTWARE PROVE DEFECTIVE, YOU (AND
*	NOT APPLE OR AN APPLE AUTHORIZED REPRESENTATIVE)
*	ASSUME THE ENTIRE COST OF ALL NECESSARY SERVICING,
*	REPAIR OR CORRECTION.
*
*	Apple does not warrant that the functions
*	contained in the Software will meet your requirements
*	or that the operation of the Software will be
*	uninterrupted or error free or that defects in the
*	Software will be corrected.
*
*	SOME STATES DO NOT ALLOW THE EXCLUSION
*	OF IMPLIED WARRANTIES, SO THE ABOVE EXCLUSION MAY
*	NOT APPLY TO YOU.  THIS WARRANTY GIVES YOU SPECIFIC
*	LEGAL RIGHTS AND YOU MAY ALSO HAVE OTHER RIGHTS
*	WHICH VARY FROM STATE TO STATE.
*/

#include <types.h>     
#include <gsos.h>                             
#include <locator.h>
#include <adb.h>
#include <intmath.h>
#include <texttool.h>
#include <memory.h>
#include <sane.h>
#include <ace.h>
#include <resources.h>
#include <misctool.h>
#include <scheduler.h>
#include <loader.h>
#include <quickdraw.h>                         
#include <qdaux.h>
#include <event.h>
#include <control.h>
#include <window.h>
#include <menu.h>
#include <lineedit.h>
#include <dialog.h>
#include <sound.h>
#include <notesyn.h>
#include <noteseq.h>
#include <midi.h>
#include <Stdfile.h>
#include <scrap.h>
#include <desk.h>
#include <list.h>
#include <font.h>
#include <print.h>
#include <textedit.h>
#include <video.h>

/* part of C libraries */
extern int	_toolErr;

/******************************************************************************
*	Application specific defines
*/

/*	menu item numbers for standard DA menu items */
#define UndoID	250	
#define CutID	251
#define CopyID  252
#define PasteID 253
#define ClearID 254
#define CloseID 255

/* application menu item numbers */
#define AboutID 0x1101
#define QuitID  0x1202

/* menu numbers */
#define AppleMenuID 0x1100
#define FileMenuID  0x1200
#define EditMenuID  0x1300

/* resource ID numbers */
#define BaseResID		0x00000000L	/* start of resource ID numbers */
#define	MenuBarOneRID	0x00001000L	/* resource ID of menu bar */

/* Let TaskMaster do it all! */
#define	MyTaskMask		0x001FFFFFL


/******************************************************************************
*	Standard global variables here
*/

int		MyMemoryID;					/* application's memory ID */
boolean Done;						/* True after Quit menu item is selected */
long	ToolRecRef;					/* Ref returned by StartUpTools */
int		WindowKind;					/* active window's kind */


/*	  The following is the record that is used by TaskMaster to return
	  events. It is similar to a regular event record, except that there are
	  additional fields at the end. The first additional field is used to
	  convey some TaskMaster specific data back to the application. The second
	  additional field is called the TaskMask and is used to tell TaskMaster
	  what situations to handle.  In this shell, we tell TaskMaster to handle
	  everything by setting all currently defined bits to 1 (MyTaskMask). */

WmTaskRec MyEvent = {
	0,
	0L,
	0L,
	0,0,
	0,
	0L,
	MyTaskMask
};


/******************************************************************************
*
*	doQuit:		Set the Done flag to true. This tells the Event loop to exit.
*
*	Inputs:		NONE
*	Outputs:	Done set to true
*	Calls:		NONE
*/

doQuit()
{
	Done = true;
}


/******************************************************************************
*
*	doAbout:	Bring up an Alert Dialog box with our about message in it.
*
*	Inputs:		NONE
*	Outputs:	NONE
*	Calls:		NONE
*/

doAbout()
{
	/* alertFlag of 4 = reference is a Resource ID */
	AlertWindow(4,NIL,BaseResID+1);	/* toss result returned by this call */
}


/******************************************************************************
*
* doMenu:		This routine is called when TaskMaster returns a menu
*				event. It takes the menu item that was hit and calls the
*				proper routine, and then unhilites the menu when it is done.
*
*	Inputs:		TaskData holds menu item selected.
*	Outputs:	NONE
*	Calls:		doAbout, doQuit
*/

doMenu()
{
	int	menuNum;
	int	itemNum;
	
	menuNum = HiWord(MyEvent.wmTaskData);	/* get menu ID */
	itemNum = LoWord(MyEvent.wmTaskData);	/* and item ID from MyEvent */
	
	switch (itemNum) {
		case AboutID:
			doAbout();	/* show About alert */
			break;
		case QuitID:
			doQuit();	/* set Done flag */
			break;
		case UndoID:
		case CutID:
		case CopyID:
		case PasteID:
		case ClearID:
		case CloseID:	/* close taken care of by TaskMaster */
			break;
		default:
			/* alertFlag of 4 = reference is a Resource ID */
			AlertWindow(4,NIL,BaseResID+2);
			break;	/* toss result returned by this call */
	}

	/* The routine has been called. Unhilite the menu and return to the */
	/* Main Event Loop. */
	
	HiliteMenu(false,menuNum);
}


/******************************************************************************
*
*	doSysChange:	Called by testTopWindow when the active window
*					has changed to or from a system window.
*
*	Inputs:			Bit 15 of WindowKind is 0 if top window is an application
*					window, 1 if top window is a system window.
*	Outputs:		NONE
*	Calls:			NONE
*/

doSysChange()
{
	if (WindowKind & 0x8000) {
		EnableMItem(UndoID);
		EnableMItem(CutID);
		EnableMItem(CopyID);
		EnableMItem(PasteID);
		EnableMItem(ClearID);
		EnableMItem(CloseID);
		
		/* if your edit menu has items that are selectable when a NDA is not
		   the active window, remove the next two lines. */
		SetMenuFlag(enableMenu,EditMenuID);
		HiliteMenu(false,EditMenuID);
	}
	else {
		DisableMItem(UndoID);
		DisableMItem(CutID);
		DisableMItem(CopyID);
		DisableMItem(PasteID);
		DisableMItem(ClearID);
		DisableMItem(CloseID);
	
		/* if your edit menu has items that are selectable when a NDA is not
		   the active window, remove the next two lines. */
		SetMenuFlag(disableMenu,EditMenuID);
		HiliteMenu(false,EditMenuID);
	}
}


/******************************************************************************
*
*	testTopWindow:	This routine is called on every time through the event
*					loop.  If the type to the top window has changed from
*					application window to system window or back, this routine
*					will call doSysChange.
*
*	Inputs:			NONE
*	Outputs:		NONE
*	Calls:			doSysChange
*/

testTopWindow()
{
	WindowPtr		tempWindowPtr;
	unsigned int	tempWindowKind;
	
	tempWindowPtr = FrontWindow();		/* get active window's grafPort */

	tempWindowKind = 0;				/* force to application window kind */
	if (tempWindowPtr)					/* if there is an active window */
		tempWindowKind = GetWKind(tempWindowPtr);	/* get its kind */			
	
	if (tempWindowKind != WindowKind) {
		WindowKind = tempWindowKind;
		doSysChange();
	}
}


/******************************************************************************
*
*	closeTools:	Shut down the tools I started.
*
*	Inputs:		NONE
*	Outputs:	NONE
*	Calls:		NONE
*/

closeTools()
{
	/* shut down tools started by StartUpTools */
	ShutDownTools(refIsHandle,ToolRecRef);
	
	/* shut down Memory Manager and Tool Locator */
	MMShutDown(MyMemoryID);
	TLShutDown();
}


/******************************************************************************
*
*	closeApp:	Close down things. This disposes of all items and
*				memory that we allocated. Usually undoes what was done
*				in initApp.  We don't close our window since _WindShutDown
*				does it for us.
*
*	Inputs:		NONE
*	Outputs:	NONE
*	Calls:		NONE
*/					

closeApp()
{
	/* do nothing in this shell */
}


/******************************************************************************
*
*	eventLoop:	Main Event Loop. Handle things until user selects Quit.
*
*	Inputs:		NONE
*	Outputs:	NONE
*	Calls:		testTopWindow, doMenu
*/

eventLoop()
{
	word taskCode;
	
	do {
		testTopWindow();		/* test top window to see if it's a NDA */
		
		/* Get event from TaskMaster */
		taskCode = TaskMaster(everyEvent,&MyEvent);
		switch (taskCode) {		/* handle the event for this taskcode */
			/* 	With most of these events, we do nothing (in fact, most
				applications will never see some of these events). You
				should cut the case labels for events your application does
				not use out of this switch statement.  Any of these events
				your application does use should call a function to handle
				the event and then use a break statement to terminate the
				rest of the switch statement.
			*/
			case nullEvt:
			case mouseDownEvt:
			case mouseUpEvt:
			case keyDownEvt:
			case autoKeyEvt:
			case updateEvt:	
			case activateEvt:
			case switchEvt:
			case deskAccEvt:
			case driverEvt:
			case app1Evt:
			case app2Evt:
			case app3Evt:
			case app4Evt:
			case wInDesk:
				break;
			case wInMenuBar:	/* do "In system menu bar" events and */
			case wInSpecial:	/* "Item ID selected was 250-255" events */
				doMenu();
				break;
			case wClickCalled:
			case wInContent:
			case wInDrag:
			case wInGrow:
			case wInGoAway:
			case wInZoom:
			case wInInfo:
				break;
			case wInDeskItem:
			case wInFrame:
			case wInactMenu:
			case wClosedNDA:
			case wCalledSysEdit:
			case wTrackZoom:
			case wHitFrame:
			case wInControl:
			case wInControlMenu:
				break; 
		}
	} while (!Done);			/* Loop until "Quit" is selected */
}


/******************************************************************************
*
*	initApp:	Perform any application specific initialization. For
*				this app,  we do is initialize the Done to false,
*				set WindowKind to an application window kind, and initialize
*				all of the menus.
*
*				You might use this procedure to create windows,
*				initialize variables and allocate memory needed for
*				the entire program.
*
*	Inputs:		NONE
*	Outputs:	NONE
*	Calls:		NONE
*/					

initApp()
{
	Done = false;					/* we aren't done yet */
	
	WindowKind = 0;					/* window kind  = application */

	/* create default system menu bar from a resource
	   and make it the current menu bar */
	   
	SetSysBar(NewMenuBar2(refIsResource,MenuBarOneRID,NIL));
	SetMenuBar(NIL);
	
	RefreshDesktop(NIL);			/* redraw the desktop */
	
	InitCursor();					/* normal arrow cursor */
	
	FixAppleMenu(AppleMenuID);		/* add NDAs to Apple menu */
	FixMenuBar();					/* set menu bar height and toss result */
	DrawMenuBar();					/* draw the menu bar */
}


/******************************************************************************
*
*	errorCheck:	This routine is called by initTools to check for startup
*				errors. An error message is shown and everything is
*				shut down if any errors are detected.
*
*	Inputs:		where = the reference number that tells you where in the
*				initTools procedure the error happened.
*	Outputs:	NONE (program exits)
*	Calls:		closeTools
*/

/*	The error message is done in this strange way (stuffing hex into the
	middle of a string with Int2Hex) because doing it with a sprintf will
	link in about 20k of code just for this operation.  We don't want to
	do that if we don't have to.  If your application has a need for printf,
	then you may wish to change the way that this works, since you will be
	linking in the 20k for something else anyway.  If you don't do any other
	printf type things, leave this routine the way it is.
*/

char errStr[] = 
	"Fatal error $xxxx has occurred at xxxx. Press any key to exit:";

void errorCheck(where)
	int where;
{
	int theError;
	
	if (_toolErr) {
		theError = _toolErr;				/* store the error number */
		Int2Hex(theError,errStr + 13, 4);	/* Stick error # into a string */
		Int2Hex(where, errStr + 34, 4);		/* Stick loc # into a string */
		
		GrafOff();							/* Turn off Super Hires */
		WriteCString(errStr);				/* write errStr to text screen */
		SysBeep();							/* ring the bell */
		ReadChar(noEcho);					/* wait for keypress & toss it */

		closeTools();						/* ShutDown my Tools */
		exit(1);							/* quit with APW status = 1 */
	}
}


/******************************************************************************
*
* initTools:	Load and startup the tools needed. errorCheck is called
*				after each startup to check for errors.
*
*	Inputs:		NONE
*	Outputs:	NONE
*	Calls:		errorCheck
*/					

initTools()
{
	TLStartUp();				/* start up Tool Locator   */
	errorCheck(1);				/* Make sure all is OK */
	
	MyMemoryID = MMStartUp();	/* start up Memory Manager & get Memory ID */
	errorCheck(2);				/* Make sure all is OK	   */

	/* Start up the rest of the tools */
	ToolRecRef = StartUpTools(MyMemoryID,refIsResource,BaseResID+1);
	errorCheck(3);				/* Make sure all is OK */
}


/******************************************************************************
*
*	main:		This is the main routine. It calls functions to startup
*				the tools, initialize application specific data, run the
*				main eventLoop, close the application, and shutdown the tools.
*				
*	Inputs:		NONE
*	Outputs:	NONE
*	Calls:		initTools, initApp, eventLoop, closeApp, closeTools
*/					

main()
{
	initTools();			/* Initialize tools. */
	initApp();				/* Initialize application specific stuff. */

	eventLoop();			/* Do application stuff until user wants to */
							/* do something else!						*/

	closeApp();				/* ShutDown application specific things. */
	closeTools();			/* ShutDown the tools. */
}
